/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdripper.jei;

import dev.ftb.mods.ftbdripper.item.FTBDripperItems;
import dev.ftb.mods.ftbdripper.recipe.DripRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class DripperCategory
implements IRecipeCategory<DripRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ftbdripper:drip");
    private final Component title = new TranslatableComponent("block.ftbdripper.dripper");
    private final IDrawable background;
    private final IDrawable icon;

    public DripperCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("ftbdripper:textures/gui/drip_jei.png"), 0, 0, 91, 30).setTextureSize(128, 64).build();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)FTBDripperItems.DRIPPER.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DripRecipe> getRecipeClass() {
        return DripRecipe.class;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DripRecipe recipe, List<? extends IFocus<?>> focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 7).addItemStack(recipe.outputItem);
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 7).addIngredient(VanillaTypes.ITEM, (Object)recipe.inputItem);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 3, 7).addIngredient(VanillaTypes.FLUID, (Object)new FluidStack(recipe.fluid, 1000))).addTooltipCallback((recipeSlotView, list) -> {
            if (recipe.chance < 1.0) {
                String s = String.valueOf(recipe.chance * 100.0);
                list.add(new TextComponent("Chance: " + (s.endsWith(".0") ? s.substring(0, s.length() - 2) : s) + "%").m_130940_(ChatFormatting.YELLOW));
            }
        });
    }
}

